/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.lib39.core.api.util;

import java.util.NoSuchElementException;

public abstract class AbstractLatchReference<T> {
    private boolean set;
    private boolean present;
    private T value;

    public void set(T value) {
        if (this.set) {
            throw new IllegalStateException("Latch already set");
        }
        this.set = true;
        this.present = true;
        this.value = value;
    }

    public void setEmpty() {
        if (this.set) {
            throw new IllegalStateException("Latch already set");
        }
        this.set = true;
        this.present = false;
        this.value = null;
    }

    public void latch() {
        if (!this.isSet()) {
            this.setEmpty();
        }
    }

    public boolean isSet() {
        return this.set;
    }

    public boolean isPresent() {
        return this.set && this.present;
    }

    public T get() {
        if (!this.isSet()) {
            throw new IllegalStateException("Latch has not been set");
        }
        if (!this.isPresent()) {
            throw new NoSuchElementException("Latch is empty");
        }
        return this.value;
    }

    public T orElse(T t) {
        return this.isPresent() ? this.get() : t;
    }
}

